<?php
/**
 * default library
 * 
 * @author     Thomas Meyer
 * @license    http://creativecommons.org/licenses/by-nc-sa/2.5/
 * @package    yana
 * @subpackage plugins
 */

/**
 * Default library for common functions
 *
 * This plugin is important. It provides functionality
 * that might be usefull for other plugins.
 *
 * @access     public
 * @package    yana
 * @subpackage plugins
 */
 class plugin_default_library extends Plugin
{

    /**
     * Default event handler
     *
     * returns bool(true) on success and bool(false) on error
     *
     * @access  public
     * @return  bool
     * @param   string  $event  name of the called event in lower-case
     * @param   array   $ARGS   array of arguments passed to the function
     * @ignore
     */
    function _default($event, $ARGS)
    {
        /* check input data */
        assert('is_string($event);');
        assert('is_array($ARGS);');
        settype($event, "string");
        settype($ARGS, "array");
        $event = strtolower($event);
        global $YANA;

        /* BEGIN visitor-counter */
        $my_counter = new counter();
        if (empty($ARGS['id'])) {
            $id = 'default';
        } else {
            $id = $ARGS['id'];
        } 
        $YANA->setVar('BESUCHER', $my_counter->count($id));
        /* END visitor-counter */

        return true;
    }

    /**
     * Create graphical visitor counter
     *
     * Note: This function ends the program.
     *
     * parameters taken:
     *
     * <ul>
     * <li> string id </li>
     * <li> string target  </li>
     * </ul>
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function graphic_counter ($ARGS)
    {
        global $YANA;
        if (!empty($ARGS['id'])) {
            $my_counter = new counter();
            $count = $my_counter->count($ARGS['id']);
        } else {
            $my_counter = new counter();
            $count = $my_counter->count('default');
        }

        settype($ARGS['target'], 'int');

        if (headers_sent()) {
            return false;
        }
        header("Content-type: image/jpeg");
        $skinDir = $YANA->getVar("SKINDIR")."default/counter/".$ARGS['target']."/";
        if (!is_dir($skinDir)) {
            $skinDir = $YANA->getVar("SKINDIR")."default/counter/0/";
        }
        $myImage = imagecreatefromjpeg($skinDir."hintergrund.jpg");
        $myImageValues = getimagesize($skinDir."hintergrund.jpg");
        $previousImageWidths=0;
        
        if (file_exists($skinDir."blank.png")) {
            $imageValues = getimagesize($skinDir."blank.png");
            $previousImageWidths+=$imageValues[0];
        }
        
        for ($i=0; $i<strlen("$count"); $i++) {

            $image = imagecreatefrompng($skinDir.substr("$count", strlen("$count")-$i-1, 1).".png");
            $imageValues = getimagesize($skinDir.substr("$count", strlen("$count")-$i-1, 1).".png");
            $previousImageWidths+=$imageValues[0];
            if (($myImageValues[0]-$previousImageWidths) < 0 || ($myImageValues[1]-$imageValues[1]) < 0) {
               imagedestroy($image);
               imagedestroy($myImage);
               $myImage = imagecreate(325,55);
               $black   = imageColorAllocate($myImage,0,0,0);
               $white   = imageColorAllocate($myImage,255,255,255);
               imagefill($myImage,0,0,$white);
               imagestring($myImage,2,5,0,"[ERROR] image size exceeds maximum",$black);
               imagestring($myImage,2,5,10,"or value to big to be displayed",$black);
               imagestring($myImage,2,5,20,"1) check size of counter \"".$skinDir.substr("$count", strlen("$count")-$i-1, 1).".png\"",$black);
               imagestring($myImage,2,5,30,"2) check dimensions of file \"".$skinDir."hintergrund.png\"",$black);
               imagestring($myImage,2,5,40,"   are big enough for the content.",$black);
               imagepng($myImage);
               imagedestroy($myImage);
               die;
            };
            ImageCopy($myImage, $image, ($myImageValues[0]-$previousImageWidths), floor(($myImageValues[1]-$imageValues[1])/2), 0, 0, $imageValues[0], $imageValues[1]);
            imagedestroy($image);
        
        }
        
        imagejpeg($myImage);
        imagedestroy($myImage);

        die();
    }

    /**
     * Show Sitemap
     *
     * this function does not expect any arguments
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function sitemap ($ARGS)
    {
        /* this function expects no arguments */

        global $YANA;
        $id = $YANA->getVar('ID');
        if (!empty($id)) {
            $my_counter = new counter();
            $YANA->setVar('BESUCHER', $my_counter->count($id));
        } else {
            $my_counter = new counter();
            $YANA->setVar('BESUCHER', $my_counter->count('default'));
        }
        $YANA->setVar("PROFILES", $YANA->plugins->getPluginList());
        return true;
    }

    /**
     * Clear Server Template-Cache
     *
     * this function does not expect any arguments
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function clear_server_cache ($ARGS)
    {
        /* this function expects no arguments */
        smartTemplate::clearCache();
        return true;
    }

    /**
     * Create preview message
     *
     * Note: this function ends the program
     *
     * parameters taken:
     *
     * <ul>
     * <li> string eintraege    text to be previewed </li>
     * </ul>
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function preview ($ARGS)
    {
        global $YANA;
        if (!isset($ARGS['eintraege'])) {
            trigger_error("Required argument 'eintraege' has not been given.", E_USER_ERROR);
            die();
        } else if (!is_string($ARGS['eintraege'])) {
            trigger_error("Wrong argument type for argument 'eintraege'. String expected, found ".gettype($ARGS['eintraege'])." instead.", E_USER_ERROR);
            die();
        } else {
            $filename = $YANA->skin->getFile('blank');
            assert('!empty($filename);');
            $blankDoc = new smartTemplate($filename);
            $blankDoc->insert('*',$YANA->getVar("*"));
            assert('is_string($ARGS["eintraege"]);');
            $ARGS['eintraege'] = untaintInput($ARGS['eintraege'], "text", 0, YANA_ESCAPE_USERTEXT);
            $ARGS['eintraege'] = DisplayUtility::smilies($ARGS['eintraege']);
            $ARGS['eintraege'] = DisplayUtility::embeddedTags($ARGS['eintraege']);
            $blankDoc->insert('*','<div style="height: 100%; overflow: auto;">'.$ARGS['eintraege'].'</div>');
            die($blankDoc->get());
        }
    }

    /**
     * Create CAPTCHA-image
     *
     * parameters taken:
     *
     * <ul>
     * <li> int security_image_index    index of image to display </li>
     * </ul>
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function security_get_image ($ARGS)
    {
        global $YANA;
        if (headers_sent()) {
            return false;
        }
        header("Content-type: image/png");

        $imagesrc = $YANA->getVar("CONFIGDIR")."security_image/security_image".rand(0,9).".png";
        $file     = new datfile($YANA->getVar("CONFIGDIR")."security_image/security_image.dat");
       
        if (!$file->exists()) {
            $file->create();
        }
        $file->read();
        if (!$file->isEmpty()) {
            $contents = $file->get(0);
        } else {
            $contents = array();
        }

        if (!isset($contents['TIME']) || $contents['TIME'] < time() || $contents['MAX_TIME'] < time()) {
            $contents = array();
            $contents['MAX_TIME'] = time() + 10000;
            for ($i=1;$i<10;$i++)
            {
                $contents["_$i"] = "";
                for ($j=0;$j<5;$j++)
                {
                    $letter = "";
                    while (empty($letter) || strtolower($letter) == 'o' || $letter == '0' || $letter == 'l' || $letter == 'i')
                    {
                        switch (rand(0,2))
                        {
                            case 0:
                                $letter = chr(rand(65,90));
                            break;
                            case 1:
                                $letter = chr(rand(48,57));
                            break;
                            case 2:
                                $letter = chr(rand(97,122));
                            break;
                        }
                    }
                    $contents["_$i"] .= $letter;
                }
            }
        }
        $contents['TIME'] = time() + 1200;
        $file->remove(0);
        $file->insert($contents);
        $file->write();

        if (!isset($ARGS['security_image_index']) || $ARGS['security_image_index'] < 1 || $ARGS['security_image_index'] > 9) {
            $text =& $contents['_1'];
        } else {
            $text =& $contents['_'.$ARGS['security_image_index']];
        }
                               
        $myImage = imagecreatefrompng($imagesrc);
        $white   = imageColorAllocate($myImage,255,255,255);
        for ($i=0; $i<5; $i++)
        {
            imagestring($myImage,5,4+($i*9)+rand(0,1),1+rand(-1,1),$text[$i],imageColorAllocate($myImage,40+rand(-30,60),40+rand(-30,60),40+rand(-30,60)));
        }
        imagepng($myImage);
        imagedestroy($myImage);
        die();
    }

    /**
     * Test if a string matches the corresponding CAPTCHA
     *
     * parameters taken:
     *
     * <ul>
     * <li> int security_image_index    index of image to display </li>
     * <li> string security_image       text to compare with CAPTCHA </li>
     * </ul>
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function security_check_image ($ARGS)
    {
        global $YANA;
        $file = new datfile($YANA->getVar("CONFIGDIR")."security_image/security_image.dat");
        $file->read();
        if (!$file->isEmpty()) {
            $contents = $file->get(0);
        } else {
            $contents = array();
        }

        if ($contents['MAX_TIME'] < time()) {
            return false;
        } else {
            if (!isset($ARGS['security_image_index']) || $ARGS['security_image_index'] < 1 || $ARGS['security_image_index'] > 9) {
                $text =& $contents['_1'];
            } else {
                $text =& $contents['_'.$ARGS['security_image_index']];
            }
            if (!empty($text) && ($ARGS['security_image'] == $text)) {
                return true;
            } else {
                return false;
            }
        }
    }

    /**
     * Create a microsummary for a page
     *
     * Technical notes:
     *
     * parameters taken:
     *
     * <ul>
     * <li> string id    identifies summary to get </li>
     * </ul>
     *
     * Note: this function terminates program execution.
     *
     * Semantic description:
     *
     * "Microsummaries" are a Firefox 2.0 feature that allows users
     * to create dynamic bookmark titles that automatically updates
     * when the content of the bookmarked page changes.
     *
     * Have a look at what microsummaries can be:
     * <ul>
     *   <li> the numbers of downloads of a file on a download site </li>
     *   <li> the latest news on a news page </li>
     *   <li> current number of unread e-mail in the inbox of a webmail service </li>
     *   <li> current total of donations to a project </li>
     *   <li> the date of latest updates on a database </li>
     *   <li> the latest submission to a guestbook or forum </li>
     *   <li> the number of visitors currently online in a chat room </li>
     *   <li> the latest stock values aso. </li>
     * </ul>
     *
     * Examples of usage:
     * <ol>
     *  <li> Setting a microsummary from a plugin:
     *       <code>Microsummary::set($this->name, 'Summary text');</code>
     *  </li>
     *  <li> Retrieving a microsummary in a plugin:
     *       <code>$microsummary = Microsummary::get($this->name);</code>
     *  </li>
     *  <li> To indicate that a microsummary exists for your plugin
     *       add this as the last line in your plugin constructor
     *       <code>Microsummary::publish($this->name);</code>
     *  </li>
     *  <li> Calling a microsummary from a browser:
     *       <code>index.php?action=get_microsummary&target=guestbook</code>
     *       (where 'guestbook' is the name of the plugin)
     *  </li>
     * </ol>
     *
     * @access public
     * @param array $ARGS array of params passed to the function
     * @return boolean
     */
    function get_microsummary ($ARGS)
    {
        if (empty($ARGS['target']) || !is_string($ARGS['target'])) {
            print 'Error: illegal request';
            exit (1);
        } else {
            $microsummary = Microsummary::get($ARGS['target']);
            if (!empty($microsummary)) {
                print $microsummary;
                exit(0);
            } else {
                print 'No summary available';
                exit(1);
            }
        }

    }

}

//  2006, Thomas Meyer www.All-Community.de
// Copyright Hinweis nicht entfernen!
?>